#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

#include "sensor.h"

extern void Draw(void);
extern void Init(void);

// DO NOT MODIFY THESE DECLARATIONS----------------
extern "C" __declspec(dllexport) void QuerySensor(void *);
extern "C" __declspec(dllexport) void InitializeSensor(void *);
extern "C" __declspec(dllexport) void UpdateSensor(void *);
extern "C" __declspec(dllexport) void CommandSensor(void *);
extern "C" __declspec(dllexport) void ResetSensor(void *);
extern "C" __declspec(dllexport) void CloseSensor(void *);

void QuerySensor(void *sensor)
{
	// This function gets called during the Vizard initialization process.
	// Its only purpose is to set the sensor type (see choices in sensor.h),
	// so that it can be automatically made available to the user according
	// to its type.
	// No initialization or communication should be attempted at this point
	// because the device may never be requested by user (and it might not
	// even be connected!).

	//A short description of your plugin
	strcpy(((VRUTSensorObj *)sensor)->version, "Water Renderer");
	//Your plugin type e.g.( SENSOR_HEADPOS | SENSOR_HEADORI | SENSOR_QUATERNION )
	
	((VRUTSensorObj *)sensor)->type = SENSOR_ENGINE;
}


void InitializeSensor(void *sensor)
{
	//Called each time an instance is created.

	//This function will attempt to connect to the device and initialize any variables.

	//You can set the size of the data field to any value.
	//After this function is called, Vizard will allocate the
	//data field of the plugin to the size given here. Then you
	//can put any values you want in the data field and the user
	//can get those values by calling the "get" command on the
	//sensor object in the script.
	//It is suggested that the size of the data field be 7 or higher
	((VRUTSensorObj*)sensor)->dataSize = 7;

	//If you have multiple instances you can store your own unique
	//identifier in the user data fields.
	((VRUTSensorObj*)sensor)->user[0] = 0;

	//If initialization failed then set status to FALSE, if it succeeded set it to TRUE.
	((VRUTSensorObj *)sensor)->status = TRUE;

	Init();
	//LoadTexture();

}


void UpdateSensor(void *sensor)
{
	Draw(); 
}


void ResetSensor(void *sensor)
{
	// If the user were to send a reset command, do whatever makes sense to do.
}

void CommandSensor(void *sensor)
{
}

void CloseSensor(void *sensor)
{
	// Go ahead, clean up, and close files and COM ports.
	//Called only once no matter how many instances were created
}